package nemosofts.voxradio.item;

import java.io.Serializable;

public class ItemRadio implements Serializable{

	private final String id;
	private final String catID;
	private final String radioTitle;
	private final String radioUrl;
	private final String image;
	private String averageRating;
	private String totalRate;
	private final String totalViews;
	private final String categoryName;
	private Boolean isFavourite;
	private final Boolean isPremium;
	private String userRating="";
	private String userMessage="";

	public ItemRadio(String id, String catID, String radioTitle, String radioUrl, String image,
					 String averageRating, String totalRate, String totalViews, String categoryName,
					 Boolean isPremium, Boolean isFavourite) {
		this.id = id;
		this.catID = catID;
		this.radioTitle = radioTitle;
		this.radioUrl = radioUrl;
		this.image = image;
		this.averageRating = averageRating;
		this.totalRate = totalRate;
		this.totalViews = totalViews;
		this.categoryName = categoryName;
		this.isPremium = isPremium;
		this.isFavourite = isFavourite;
	}

	public String getId() {
		return id;
	}

	public String getCatID() {
		return catID;
	}

	public String getRadioTitle() {
		return radioTitle;
	}

	public String getRadioUrl() {
		return radioUrl;
	}

	public String getImage() {
		return image;
	}

	public String getAverageRating() {
		return averageRating;
	}

	public String getTotalRate() {
		return totalRate;
	}

	public void setAverageRating(String averageRating) {
		this.averageRating = averageRating;
	}

	public void setTotalRate(String totalRate) {
		this.totalRate = totalRate;
	}

	public String getTotalViews() {
		return totalViews;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public Boolean getIsPremium() {
		return isPremium;
	}

	public Boolean getIsFav() {
		return isFavourite;
	}
	public void setIsFav(Boolean favourite) {
		isFavourite = favourite;
	}

	public String getUserRating() {
		return userRating;
	}
	public void setUserRating(String userRating) {
		this.userRating = userRating;
	}

	public String getUserMessage() {
		return userMessage;
	}
	public void setUserMessage(String userMessage) {
		this.userMessage = userMessage;
	}
}